<? 
/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// The base class for an element 
class extrato 
{ 
    var $codigo = "";
    var $nome = "";
    var $tipo = "";
    var $saldoini = "";
    var $pregao = array();
    var $totaldeb = "";
    var $totalcred = "";
    var $observacao = "";

/*
    function getPregao($pos, $ocampo){
    	if($pos < sizeof($this->compras)){
            if($ocampo == "merc"){
            	return($this->compras[$pos]->merc);
            }
    	}
    	else{
    	    return(" ");
        }
    }
*/
} 

class Pregao{ 
    var $datap = "";
    var $operacao = array();
    var $totaldia = "";
}

class Operacao{ 
    var $historico = "";
    var $doc = "";
    var $debito = "";
    var $credito = "";
    var $saldo = "";
}


// don't want any warnings turning up in the pdf code if the server is set to 'anal' mode.
//error_reporting(7);
error_reporting(E_ALL);
set_time_limit(1800);

include 'class.ezpdf.php';

// define a clas extension to allow the use of a callback to get the table of contents, and to put the dots in the toc
class Creport extends Cezpdf {

var $reportContents = array();

function Creport($p,$o){
  $this->Cezpdf($p,$o);
}

function rf($info){
  // this callback records all of the table of contents entries, it also places a destination marker there
  // so that it can be linked too
  $tmp = $info['p'];
  $lvl = $tmp[0];
  $lbl = rawurldecode(substr($tmp,1));
  $num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
  $this->reportContents[] = array($lbl,$num,$lvl );
  $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
}

    function dots($info){
      // draw a dotted line over to the right and put on a page number
      $tmp = $info['p'];
      $lvl = $tmp[0];
      $lbl = substr($tmp,1);
      $xpos = 520;
    
      switch($lvl){
        case '1':
          $size=16;
          $thick=1;
          break;
        case '2':
          $size=12;
          $thick=0.5;
          break;
      }
    
      $this->saveState();
      $this->setLineStyle($thick,'round','',array(0,10));
      $this->line($xpos,$info['y'],$info['x']+5,$info['y']);
      $this->restoreState();
      $this->addText($xpos+5,$info['y'],$size,$lbl);
    
    
    }

}


class ExtratoPDF{

    function makePDF($dados, $outputArq=""){
        //===================================================================================================
        //Iniciando a geracao do pdf
        //===================================================================================================
        // this is the php file which creates the readme.pdf file, this is not seriously 
        //Teste
        //===================================================================================================
        
        
        // I am in NZ, so will design my page for A4 paper.. but don't get me started on that.
        // (defaults to legal)
        // this code has been modified to use ezpdf.
        
        //$pdf = new Cezpdf('a4','portrait');
        $pdf = new Creport('a4','portrait');
        
        $pdf -> ezSetMargins(132,70,55,55);
        
        // put a line top and bottom on all the pages
        $all = $pdf->openObject();
        $pdf->saveState();
        $pdf->setStrokeColor(0,0,0,1);
        
        
        if (file_exists('logo_terrafuturos.jpg')){
          $pdf->addJpegFromFile('logo_terrafuturos.jpg',50,760,93,46);
        }

        $size=8;
        $height = $pdf->getFontHeight($size);
        $textOptions = array('justification'=>'center');
        $collecting=0;
        $code='';

        $pdf->addText(186, 765, 10, "<b>Terra Futuros Corretora de Mercadorias S.A</b>");
        $pdf->addText(230, 800, 10, "<b>Extrato de Cliente no C/C</b>");
        $pdf->addText(467, 790, 8, "Hora: " . date("h:i:s"));
        $pdf->addText(55, 750, 8, "<b>Data                 " . date("d/m/Y") . "</b>");
        $pdf->addText(55, 737, 8, "<b>Cliente      " . trim($dados->codigo) . "    " . trim($dados->nome));
        $pdf->addText(55, 727, 8, "Tipo: " . trim($dados->tipo) . "</b>");
        $pdf->setLineStyle(1);
        $pdf->line(42,745,542,745);
        $pdf->line(42,723,542,723);
        $pdf->line(42,708,542,708);

        //Cabecalho da tabela
        $pdf->addText(47, 713, 8, "Data");
        $pdf->addText(97, 713, 8, "Histrico");
        $pdf->addText(277, 713, 8, "Doc");
        $pdf->addText(364, 713, 8, "Dbito");
        $pdf->addText(441, 713, 8, "Crdito");
        $pdf->addText(516, 713, 8, "Saldo");
        
        $pdf->restoreState();
        $pdf->closeObject();
        // note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
        // or 'even'.
        $pdf->addObject($all,'all');
        
        //$pdf->ezSetDy(-100);
        
        //$mainFont = './fonts/Helvetica.afm';
        $mainFont = './fonts/Times-Roman.afm';
        $codeFont = './fonts/Courier.afm';
        // select a font
        $pdf->selectFont($mainFont);
        
        
        // modified to use the local file if it can
        
        $pdf->openHere('Fit');
        
        $pdf->selectFont($mainFont);
        
        //-----------------------------------------------------------
        $pdf->ezStartPageNumbers(500,800,8,'','Pgina: {PAGENUM}',1);
        
        // Comeca a jogar o conteudo no PDF
        // $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        // $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.82, 0.97, 0.94), 'shadeCol2'=>array(0.82, 0.97, 0.94), 'shaded'=>2, 'cols'=> $clparam);
        $pdf->addText(330, 727, 10, "<b>Saldo Inicial    " . trim($dados->saldoini) . "</b>");
        $pdf->addText(330, 727, 10, "<b>Saldo Inicial    " . trim($dados->saldoini) . "</b>");
        $pdf->addText(330, 727, 10, "<b>Saldo Inicial    " . trim($dados->saldoini) . "</b>");

        //Dados
        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>50),
        'cl2'=>array('justification'=>'left','width'=>180),
        'cl3'=>array('justification'=>'left','width'=>40),
        'cl4'=>array('justification'=>'right','width'=>80),
        'cl5'=>array('justification'=>'right','width'=>80),
        'cl6'=>array('justification'=>'right','width'=>70)
        );
        $tbdata = array();

        for($i = 0; $i < sizeof($dados->pregao); $i++){
            $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>500, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.82, 0.97, 0.94), 'shadeCol2'=>array(0.82, 0.97, 0.94), 'shaded'=>2, 'cols'=> $clparam);
            for($k = 0; $k < sizeof($dados->pregao[$i]->operacao); $k++){
                $tbdata[] = array('cl1'=>trim($dados->pregao[$i]->datap), 'cl2'=>trim($dados->pregao[$i]->operacao[$k]->historico), 'cl3'=>trim($dados->pregao[$i]->operacao[$k]->doc), 'cl4'=>trim($dados->pregao[$i]->operacao[$k]->debito), 'cl5'=>trim($dados->pregao[$i]->operacao[$k]->credito), 'cl6'=>trim($dados->pregao[$i]->operacao[$k]->saldo));
            }

            if(sizeof($tbdata) > 0){
                $pdf->ezTable($tbdata, '', '', $opt);
            }

            $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>500, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array();
            $tbdata[] = array('cl1'=>" ", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>" ", 'cl5'=>"<b>total do dia</b>", 'cl6'=>"<b>" . trim($dados->pregao[$i]->totaldia) . "</b>");
            if(sizeof($tbdata) > 0){
                $pdf->ezTable($tbdata, '', '', $opt);
            }
            $tbdata = array();
        }


        //Rodape
        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>50),
        'cl2'=>array('justification'=>'right','width'=>180),
        'cl3'=>array('justification'=>'left','width'=>40),
        'cl4'=>array('justification'=>'right','width'=>80),
        'cl5'=>array('justification'=>'right','width'=>80),
        'cl6'=>array('justification'=>'left','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>500, 'titleFontSize'=>8, 'fontSize'=>10, 'shaded'=>0, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"", 'cl2'=>"<b>Totais do cliente", 'cl3'=>"", 'cl4'=>trim($dados->totaldeb), 'cl5'=>trim($dados->totalcred), 'cl6'=>"</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        $pdf->ezText("",8,$textOptions);
        $y2 = $pdf->ezText("",8,$textOptions);
        $yPos = $pdf->ezText(trim($dados->observacao),8,$textOptions);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,($y2 - $yPos + 5));
        
        // Fim do conteudo do PDF
        $pdf->ezStopPageNumbers(1,1);
        
        if ($outputArq != ""){
            $pdfcode = $pdf->ezOutput();
            $fp=fopen($outputArq,'wb');
            fwrite($fp,$pdfcode);
            fclose($fp);
        }
        else{
            $pdf->ezStream();
        }
    }
}


/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// Utility function to parse a XML document from a file 
function xml_parse_from_file($parser, $file) 
{ 
    if(!file_exists($file)) 
    { 
        die("Can't find file \"$file\"."); 
    } 
     
    if(!($fp = @fopen($file, "r")))  
    { 
        die("Can't open file \"$file\"."); 
    } 
     
    while($data = fread($fp, 65536)) 
    { 
        if(!xml_parse($parser, $data, feof($fp))) 
        { 
            return(false); 
        } 
    } 
     
    fclose($fp); 
     
    return(true); 
} 


function start_element($parser, $name, $attrs) 
{ 
    global $elemento, $pregao, $operacao;
    
    $elemento = $name;

    if($elemento == "OPERACAO"){
        $operacao = new Operacao;
    }

    if($elemento == "PREGAO"){
        $pregao = new Pregao;
    }

} 

function stop_element($parser, $name) 
{ 
    global $elemento, $tmp, $dados, $ultimoDado, $pregao, $operacao;

    if(($name == "CLIENTE") && $tmp != null){
        $dados[] = $tmp;
        $tmp = null;
    }

    if($name == "OPERACAO"){
        $pregao->operacao[] = $operacao;
        $operacao = null;
    }

    if($name == "PREGAO"){
        $tmp->pregao[] = $pregao;
        $pregao = null;
    }

    $ultimoDado = "";
    $elemento = "";
} 

function char_data($parser, $data) 
{ 
    global $elemento, $codigo, $pregao, $tmp, $operacao, $dados, $ultimoDado;

    if($ultimoDado == ""){
        $ultimoDado = $data;
    }
    else{
        $ultimoDado .= $data;
        $data = str_replace("\n", "", $ultimoDado);
    }

    if($elemento == "CODIGO"){
         $tmp = new extrato;
         $tmp->codigo = $data;
    }

    if($tmp != null){
        if($elemento == "NOME"){
            $tmp->nome = $data;
        }

        if($elemento == "OBSERVACAO"){
            $tmp->observacao = str_replace("[br]", "\n", $data);
        }

        if($elemento == "TIPO"){
            $tmp->tipo = $data;
        }

        if($elemento == "SALDOINI"){
            $tmp->saldoini = $data;
        }
        
        if($elemento == "TOTALDEB"){
            $tmp->totaldeb = $data;
        }

        if($elemento == "TOTALCRED"){
            $tmp->totalcred = $data;
        }
        
        if($elemento == "DATAP"){
            $pregao->datap = $data;
        }
        
        if($elemento == "HISTORICO"){
            $operacao->historico = $data;
        }

        if($elemento == "DOC"){
            $operacao->doc = $data;
        }

        if($elemento == "DEBITO"){
            $operacao->debito = $data;
        }

        if($elemento == "CREDITO"){
            $operacao->credito = $data;
        }

        if($elemento == "SALDO"){
            $operacao->saldo = $data;
        }

        if($elemento == "TOTALDIA"){
            $pregao->totaldia = $data;
            
            if($pregao->totaldia > 0){
                $pregao->totaldia = $data;
            }
            else{
                $pregao->totaldia = "(" . $data . ")";
            }
        }

    }
} 

?>