<? 
/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// The base class for an element 
class extrato{ 
    var $codigo = "";
    var $nome = "";
    var $cnpjcpf = "";
    var $endereco = "";
    var $cep = "";
    var $cidade = "";
    var $bairro = "";
    var $uf = "";
    var $dtpreg = "";
    var $dtliq = "";
    var $operacaodia = null;
    var $posliquidada = null;
    var $posaberta = null;
    var $garantia = null;
    var $movanterior = null;
    var $financeiro = null;
    var $saldocc = "";
    var $saldobmf = "";
    var $baltotal = "";
    var $saldoccwtr = "";
    var $saldobmfwtr = "";
    var $baltotalwtr = "";
    var $baseirnormal = "";
    var $baseirdaytrade = "";
    var $observacao = "";
} 

class OperacaoDia{ 
    var $operacao = array();
    var $totalajuste = "";
}

class Operacao{
    var $mercadoria = "";
    var $merc = "";
    var $cv = "";
    var $qtde = "";
    var $tipo = "";
    var $cotacao = "";
    var $ultcotacao = "";
    var $ajuval = "";
    var $cvinc = "";
}

class PosLiquidada{
    var $opliq = array();
    var $daytrade = "";
    var $daytradecusto = "";
    var $daytradeajuste = "";
    var $posicao = "";
    var $posicaocusto = "";
    var $posicaoajuste = "";
    var $resultado = "";
    var $resultadocusto = "";
    var $resultadoajuste = "";
}

class OpLiq{
    var $data = "";
    var $tp = "";
    var $compra = "";
    var $venda = "";
    var $mercadliq = "";
    var $cotacaoliq = "";
    var $custo = "";
    var $ajuliq = "";
    var $resultliq = "";
}

class PosAberta{
    var $opmercadoria = array();
    var $totalcusto = "";
}

class OpMercadoria{
    var $opaberta = array();
    var $qtdtotpormerc = "";
    var $resulttotpormerc = "";
}

class OpAberta{
    var $mercadoriaabr = "";
    var $mercabr = "";
    var $posabr = "";
    var $venctoabr = "";
    var $cvabr = "";
    var $qtdeabr = "";
    var $precomedioabr = "";
    var $resultadoabr = "";
}

class Garantia{
    var $ouroaloc = "";
    var $ourousado = "";
    var $ourobal = "";
    var $ativoaloc = "";
    var $ativousado = "";
    var $ativobal = "";
    var $dinheiroaloc = "";
    var $dinheirousado = "";
    var $dinheirobal = "";
    var $dinheirodev = "";
    var $margemreq = "";
    var $totalaloc = "";
    var $totalusado = "";
    var $totaldev = "";
    var $totalbal = "";
}

class Movanterior{
    var $movimento = array();
    var $movdata = "";
    var $movinicial = "";
    var $movsaldo = "";
}

class Movimento{
    var $datamov = "";
    var $movdescricao = "";
    var $movvalor = "";
}

class Financeiro{
    var $ativo = array();
    var $balancobmf = "";
}

class Ativo{
    var $nomeativo = "";
    var $opfinanceiro = array();
    var $totalativo = "";
}

class OpFinanceiro{
    var $historico = "";
    var $debitofin = "";
    var $creditofin = "";
}

// don't want any warnings turning up in the pdf code if the server is set to 'anal' mode.
//error_reporting(7);
error_reporting(E_ALL);
set_time_limit(1800);

include 'class.ezpdf.php';

// define a clas extension to allow the use of a callback to get the table of contents, and to put the dots in the toc
class Creport extends Cezpdf {

var $reportContents = array();

function Creport($p,$o){
  $this->Cezpdf($p,$o);
}

function rf($info){
  // this callback records all of the table of contents entries, it also places a destination marker there
  // so that it can be linked too
  $tmp = $info['p'];
  $lvl = $tmp[0];
  $lbl = rawurldecode(substr($tmp,1));
  $num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
  $this->reportContents[] = array($lbl,$num,$lvl );
  $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
}

    function dots($info){
      // draw a dotted line over to the right and put on a page number
      $tmp = $info['p'];
      $lvl = $tmp[0];
      $lbl = substr($tmp,1);
      $xpos = 520;
    
      switch($lvl){
        case '1':
          $size=16;
          $thick=1;
          break;
        case '2':
          $size=12;
          $thick=0.5;
          break;
      }
    
      $this->saveState();
      $this->setLineStyle($thick,'round','',array(0,10));
      $this->line($xpos,$info['y'],$info['x']+5,$info['y']);
      $this->restoreState();
      $this->addText($xpos+5,$info['y'],$size,$lbl);
    
    
    }

}


class ExtratoPDF{

    function makePDF($dados, $outputArq=""){
            
        //===================================================================================================
        //Iniciando a geracao do pdf
        //===================================================================================================
        // this is the php file which creates the readme.pdf file, this is not seriously 
        //Teste
        //===================================================================================================
        
        
        // I am in NZ, so will design my page for A4 paper.. but don't get me started on that.
        // (defaults to legal)
        // this code has been modified to use ezpdf.
        
        //$pdf = new Cezpdf('a4','portrait');
        $pdf = new Creport('a4','portrait');
        $pdf -> ezSetMargins(100,50,55,55);

        //$mainFont = './fonts/Helvetica.afm';
        $mainFont = './fonts/Times-Roman.afm';
        $codeFont = './fonts/Courier.afm';
        // select a font
        $pdf->selectFont($mainFont);
        
        // put a line top and bottom on all the pages
        $all = $pdf->openObject();
        $pdf->saveState();
        $pdf->setStrokeColor(0,0,0,1);
        
        
        if (file_exists('logo_terrafuturos.jpg')){
          $pdf->addJpegFromFile('logo_terrafuturos.jpg',50,780,63,31);
        }
        $pdf->setColor(0.71, 0.92, 0.88);
        $pdf->filledRectangle(50,763,310,12);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(50,763,310,12);
        $pdf->addText(52, 765, 10, "<b>Terra Futuros Corretora de Mercadorias S.A.</b>");
        $pdf->addText(230, 800, 10, "<b>Extrato de Cliente B.M. & F.</b>");
        $pdf->addText(467, 780, 8, "Hora: " . date("h:i:s"));
        $pdf->addText(50, 750, 8, "<b>Data:</b> " . date("d/m/Y"));
        $pdf->addText(200, 750, 8, "<b>Data do Prego:</b> " . $dados->dtpreg);
        $pdf->addText(350, 750, 8, "<b>Data de Liquidao:</b> " . $dados->dtliq);
        
        //$pdf->line(20,40,578,40);
        $pdf->restoreState();
        $pdf->closeObject();
        // note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
        // or 'even'.
        $pdf->addObject($all,'all');
        
        //$pdf->ezSetDy(-100);
        
        // modified to use the local file if it can
        
        $pdf->openHere('Fit');
        
        $pdf->selectFont($mainFont);
        
        //-----------------------------------------------------------
        $pdf->ezStartPageNumbers(520,800,8,'','Pgina: {PAGENUM}  de  {TOTALPAGENUM}',1);
        
        $size=8;
        $height = $pdf->getFontHeight($size);
        $textOptions = array('justification'=>'center');
        $collecting=0;
        $code='';
        //Variavel para guardar a ultima posicao vertical usada
        $yPos = 0;        

        // Comeca a jogar o conteudo no PDF

        //cabecalho cliente
        $pdf->rectangle(45,705,495,35);        
        $pdf->addText(52, 730, 8, "<b>Cliente:</b>         " . $dados->codigo . "        " . $dados->nome);
        $pdf->addText(60, 720, 8, $dados->endereco);
        $pdf->addText(52, 710, 8, "<b>CEP:</b>    " . $dados->cep . "        " . $dados->cidade . "        " . $dados->uf . "        " . $dados->bairro);
        $pdf->addText(350, 710, 8, "<b>CNPJ/CPF:</b>         " . $dados->cnpjcpf);

        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText("<b>Operao do Dia</b>",$size,$textOptions);

        //Cabecalho da tabela - operacoes dia
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>65),
        'cl2'=>array('justification'=>'center','width'=>50),
        'cl3'=>array('justification'=>'center','width'=>40),
        'cl4'=>array('justification'=>'center','width'=>45),
        'cl5'=>array('justification'=>'center','width'=>55),
        'cl6'=>array('justification'=>'center','width'=>70),
        'cl7'=>array('justification'=>'center','width'=>70),
        'cl8'=>array('justification'=>'center','width'=>60),
        'cl9'=>array('justification'=>'center','width'=>40)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Mercadoria", 'cl2'=>"Merc.", 'cl3'=>"C/V", 'cl4'=>"Qtde.", 'cl5'=>"Tipo", 'cl6'=>"Cotao", 'cl7'=>"Ult. Cotao", 'cl8'=>"Aju./Val.</b>", 'cl9'=>"Cli. Vinc</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        //dados - operacao dia
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>65),
        'cl2'=>array('justification'=>'center','width'=>50),
        'cl3'=>array('justification'=>'center','width'=>40),
        'cl4'=>array('justification'=>'center','width'=>45),
        'cl5'=>array('justification'=>'center','width'=>55),
        'cl6'=>array('justification'=>'center','width'=>70),
        'cl7'=>array('justification'=>'center','width'=>70),
        'cl8'=>array('justification'=>'center','width'=>60),
        'cl9'=>array('justification'=>'center','width'=>40)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.82, 0.97, 0.94), 'shadeCol2'=>array(0.82, 0.97, 0.94), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array();
      
        for($i = 0; $i < sizeof($dados->operacaodia->operacao); $i++){
             $tbdata[] = array('cl1'=>$dados->operacaodia->operacao[$i]->mercadoria, 'cl2'=>$dados->operacaodia->operacao[$i]->merc, 'cl3'=>$dados->operacaodia->operacao[$i]->cv, 'cl4'=>$dados->operacaodia->operacao[$i]->qtde, 'cl5'=>$dados->operacaodia->operacao[$i]->tipo, 'cl6'=>$dados->operacaodia->operacao[$i]->cotacao, 'cl7'=>$dados->operacaodia->operacao[$i]->ultcotacao, 'cl8'=>$dados->operacaodia->operacao[$i]->ajuval, 'cl9'=>$dados->operacaodia->operacao[$i]->cvinc);
        }
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        //Total do Ajuste
        $pdf->ezText(" ",$size,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'right','width'=>70),
        'cl2'=>array('justification'=>'right','width'=>65),
        'cl3'=>array('justification'=>'right','width'=>40)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>170, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam, 'xPos'=>457);
        $tbdata = array();
        $tbdata[] = array('cl1'=>"<b>Total do Ajuste: </b>", 'cl2'=>$dados->operacaodia->totalajuste, 'cl3'=>" ");
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(365,($yPos - 1),175,13);



        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText("<b>Posio Liquidada</b>",$size,$textOptions);

        //Cabecalho da tabela - pos liquidada
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>60),
        'cl2'=>array('justification'=>'center','width'=>35),
        'cl3'=>array('justification'=>'center','width'=>50),
        'cl4'=>array('justification'=>'center','width'=>50),
        'cl5'=>array('justification'=>'center','width'=>55),
        'cl6'=>array('justification'=>'center','width'=>65),        
        'cl7'=>array('justification'=>'center','width'=>55),
        'cl8'=>array('justification'=>'center','width'=>55),
        'cl9'=>array('justification'=>'center','width'=>70)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Data", 'cl2'=>"TP", 'cl3'=>"Compra", 'cl4'=>"Venda", 'cl5'=>"Mercadoria", 'cl6'=>"Cotao", 'cl7'=>"Custo", 'cl8'=>"Ajuste", 'cl9'=>"Resultado</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        //dados - pos liquidada
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>60),
        'cl2'=>array('justification'=>'center','width'=>35),
        'cl3'=>array('justification'=>'center','width'=>50),
        'cl4'=>array('justification'=>'center','width'=>50),
        'cl5'=>array('justification'=>'center','width'=>55),
        'cl6'=>array('justification'=>'right','width'=>65),        
        'cl7'=>array('justification'=>'right','width'=>55),
        'cl8'=>array('justification'=>'right','width'=>55),
        'cl9'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array();
        
        
        $liqtmp = $dados->posliquidada->opliq[0]->mercadliq;
        for($i = 0; $i < sizeof($dados->posliquidada->opliq); $i++){
             if($dados->posliquidada->opliq[$i]->mercadliq == $liqtmp){
                $tbdata[] = array('cl1'=>$dados->posliquidada->opliq[$i]->data, 'cl2'=>$dados->posliquidada->opliq[$i]->tp, 'cl3'=>$dados->posliquidada->opliq[$i]->compra, 'cl4'=>$dados->posliquidada->opliq[$i]->venda, 'cl5'=>$dados->posliquidada->opliq[$i]->mercadliq, 'cl6'=>$dados->posliquidada->opliq[$i]->cotacaoliq, 'cl7'=>$dados->posliquidada->opliq[$i]->custo, 'cl8'=>$dados->posliquidada->opliq[$i]->ajuliq, 'cl9'=>$dados->posliquidada->opliq[$i]->resultliq);
             }
             else{
                $yPos = $pdf->ezTable($tbdata, '', '', $opt);
                $tbdata = array();
                $tbdata[] = array('cl1'=>$dados->posliquidada->opliq[$i]->data, 'cl2'=>$dados->posliquidada->opliq[$i]->tp, 'cl3'=>$dados->posliquidada->opliq[$i]->compra, 'cl4'=>$dados->posliquidada->opliq[$i]->venda, 'cl5'=>$dados->posliquidada->opliq[$i]->mercadliq, 'cl6'=>$dados->posliquidada->opliq[$i]->cotacaoliq, 'cl7'=>$dados->posliquidada->opliq[$i]->custo, 'cl8'=>$dados->posliquidada->opliq[$i]->ajuliq, 'cl9'=>$dados->posliquidada->opliq[$i]->resultliq);
                $liqtmp = $dados->posliquidada->opliq[$i]->mercadliq;
             }
        }
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);


        //Day Trade
        $pdf->ezText(" ",$size,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'right','width'=>70),
        'cl2'=>array('justification'=>'right','width'=>55),
        'cl3'=>array('justification'=>'right','width'=>55),
        'cl4'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>250, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam, 'xPos'=>420);
        $tbdata = array();
        $tbdata[] = array('cl1'=>"<b>Day-Trade: </b>", 'cl2'=>$dados->posliquidada->daytradecusto, 'cl3'=>$dados->posliquidada->daytradeajuste, 'cl4'=>$dados->posliquidada->daytrade);
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(290,($yPos - 1),250,13);

        //posicao
        $pdf->ezText(" ",$size,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'right','width'=>70),
        'cl2'=>array('justification'=>'right','width'=>55),
        'cl3'=>array('justification'=>'right','width'=>55),
        'cl4'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>250, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam, 'xPos'=>420);
        $tbdata = array();
        $tbdata[] = array('cl1'=>"<b>Posio: </b>", 'cl2'=>$dados->posliquidada->posicaocusto, 'cl3'=>$dados->posliquidada->posicaoajuste, 'cl4'=>$dados->posliquidada->posicao);
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(290,($yPos - 1),250,13);

        //resultado
        $pdf->ezText(" ",$size,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'right','width'=>70),
        'cl2'=>array('justification'=>'right','width'=>55),
        'cl3'=>array('justification'=>'right','width'=>55),
        'cl4'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>250, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam, 'xPos'=>420);
        $tbdata = array();
        $tbdata[] = array('cl1'=>"<b>Resultado: </b>", 'cl2'=>$dados->posliquidada->resultadocusto, 'cl3'=>$dados->posliquidada->resultadoajuste, 'cl4'=>$dados->posliquidada->resultado);
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(290,($yPos - 1),250,13);

        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,70);


        //Cabecalho da tabela - pos aberta
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",6,$textOptions);
        $pdf->ezText("<b>Posio Aberta</b>",$size,$textOptions);

        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>60),
        'cl2'=>array('justification'=>'center','width'=>60),
        'cl3'=>array('justification'=>'center','width'=>60),
        'cl4'=>array('justification'=>'center','width'=>60),
        'cl5'=>array('justification'=>'center','width'=>60),
        'cl6'=>array('justification'=>'center','width'=>65),
        'cl7'=>array('justification'=>'center','width'=>65),
        'cl8'=>array('justification'=>'center','width'=>65)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Mercadoria", 'cl2'=>"Mercado", 'cl3'=>"Exerccio", 'cl4'=>"Vencto.", 'cl5'=>"C/V", 'cl6'=>"Qtde.", 'cl7'=>"Preo Mdio", 'cl8'=>"Resultado</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        //dados - pos aberta
        $clparam2 = array(
        'cl1'=>array('justification'=>'right','width'=>300),
        'cl2'=>array('justification'=>'center','width'=>65),
        'cl3'=>array('justification'=>'center','width'=>65),
        'cl4'=>array('justification'=>'right','width'=>65)
        );
        $opt2 = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam2);

        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>60),
        'cl2'=>array('justification'=>'center','width'=>60),
        'cl3'=>array('justification'=>'center','width'=>60),
        'cl4'=>array('justification'=>'center','width'=>60),
        'cl5'=>array('justification'=>'center','width'=>60),
        'cl6'=>array('justification'=>'center','width'=>65),
        'cl7'=>array('justification'=>'right','width'=>65),
        'cl8'=>array('justification'=>'right','width'=>65)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);

        for($k = 0; $k < sizeof($dados->posaberta->opmercadoria); $k++){
            $tbdata2 = array();
            $tbdata2[] = array('cl1'=>"<b>Total do Ativo:", 'cl2'=>$dados->posaberta->opmercadoria[$k]->qtdtotpormerc, 'cl3'=>" ", 'cl4'=>$dados->posaberta->opmercadoria[$k]->resulttotpormerc . "</b>");

            $tbdata = array();
            for($i = 0; $i < sizeof($dados->posaberta->opmercadoria[$k]->opaberta); $i++){
                $tbdata[] = array('cl1'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->mercadoriaabr, 'cl2'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->mercabr, 'cl3'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->posabr, 'cl4'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->venctoabr, 'cl5'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->cvabr, 'cl6'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->qtdeabr, 'cl7'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->precomedioabr, 'cl8'=>$dados->posaberta->opmercadoria[$k]->opaberta[$i]->resultadoabr);
            }

            $pdf->ezTable($tbdata, '', '', $opt);
            $yPos = $pdf->ezTable($tbdata2, '', '', $opt2);
        }

        //Custo Total
        $pdf->ezText(" ",$size,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'right','width'=>100),
        'cl2'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>170, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam, 'xPos'=>460);
        $tbdata = array();
        $tbdata[] = array('cl1'=>"<b>Custo Total: </b>", 'cl2'=>$dados->posaberta->totalcusto);
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(370,($yPos - 1),170,13);


        //Cabecalho da tabela - garantia
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",6,$textOptions);
        $pdf->ezText("<b>Garantia</b>",$size,$textOptions);

        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>100),
        'cl2'=>array('justification'=>'right','width'=>100),
        'cl3'=>array('justification'=>'right','width'=>100),
        'cl4'=>array('justification'=>'right','width'=>95),
        'cl5'=>array('justification'=>'right','width'=>100)
        );

        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Margem Total:", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>" ", 'cl5'=>$dados->garantia->margemreq."</b>")
        );
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>" ", 'cl2'=>"<b><u>Alocado", 'cl3'=>"Usado", 'cl4'=>"Chamada/Devoluo   ", 'cl5'=>"Saldo  </u></b>        "),
         array('cl1'=>"<b>Ouro: </b>", 'cl2'=>$dados->garantia->ouroaloc, 'cl3'=>$dados->garantia->ourousado, 'cl4'=>"00", 'cl5'=>$dados->garantia->ourobal . "        "),
         array('cl1'=>"<b>Ativos: </b>", 'cl2'=>$dados->garantia->ativoaloc, 'cl3'=>$dados->garantia->ativousado, 'cl4'=>"00", 'cl5'=>$dados->garantia->ativobal . "        "),
         array('cl1'=>"<b>Dinheiro: </b>", 'cl2'=>$dados->garantia->dinheiroaloc, 'cl3'=>$dados->garantia->dinheirousado, 'cl4'=>$dados->garantia->dinheirodev, 'cl5'=>$dados->garantia->dinheirobal . "        "),
         array('cl1'=>"<b>Total", 'cl2'=>$dados->garantia->totalaloc, 'cl3'=>$dados->garantia->totalusado, 'cl4'=>$dados->garantia->totaldev, 'cl5'=>$dados->garantia->totalbal . "        ")
        );
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,57);
        $pdf->rectangle(45,($yPos - 5),495,68);
        $pdf->line(49, ($yPos + 9), 535, ($yPos + 9));


        //Cabecalho da tabela - financeiro
        $pdf->ezText(" ",6,$textOptions);        
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText("Resumo Financeiro",$size,$textOptions);

        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>375),
        'cl2'=>array('justification'=>'center','width'=>60),
        'cl3'=>array('justification'=>'center','width'=>60)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $spcr = "                              ";
        $tbdata = array(
         array('cl1'=>"$spcr<b>Histrico", 'cl2'=>"Dbito", 'cl3'=>"Crdito</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        for($i = 0; $i < sizeof($dados->financeiro->ativo); $i++){
            //nome do ativo
            $clparam = array(
            'cl1'=>array('justification'=>'left','width'=>495)
            );
            $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array(
             array('cl1'=>"<b>Ativo: </b>    " . $dados->financeiro->ativo[$i]->nomeativo)
            );
            $pdf->ezTable($tbdata, '', '', $opt);

            //dados
            $clparam = array(
            'cl1'=>array('justification'=>'left','width'=>375),
            'cl2'=>array('justification'=>'right','width'=>60),
            'cl3'=>array('justification'=>'right','width'=>60)
            );
            $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array();
            
            $spcr = "                              ";
            for($k = 0; $k < sizeof($dados->financeiro->ativo[$i]->opfinanceiro); $k++){
                $tbdata[] = array('cl1'=>$spcr . $dados->financeiro->ativo[$i]->opfinanceiro[$k]->historico, 'cl2'=>$dados->financeiro->ativo[$i]->opfinanceiro[$k]->debitofin, 'cl3'=>$dados->financeiro->ativo[$i]->opfinanceiro[$k]->creditofin);
            }
            $pdf->ezTable($tbdata, '', '', $opt);

            //total do ativo
            $clparam = array(
            'cl1'=>array('justification'=>'right','width'=>495)
            );
            $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array(
             array('cl1'=>"<b>Total do Ativo: </b>    " . $dados->financeiro->ativo[$i]->totalativo . "                      ")
            );
            $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        }

        //balanco do cliente bmf
        //$pdf->ezText(" ",6,$textOptions);
        //$clparam = array(
        //'cl1'=>array('justification'=>'center','width'=>300),
        //'cl2'=>array('justification'=>'right','width'=>195)
        //);
        //$opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1, 1, 1), 'shadeCol2'=>array(1, 1, 1), 'shaded'=>2, 'cols'=> $clparam);
        //$tbdata = array(
        // array('cl1'=>"<b>Balano do Cliente B. M. & F.", 'cl2'=>$dados->financeiro->balancobmf . "</b>                      ")
        //);
        //$yPos = $pdf->ezTable($tbdata, '', '', $opt);
        //
        //$pdf->setStrokeColor(0,0,0,1);
        //$pdf->setColor(0, 0, 0);
        //$pdf->rectangle(45,($yPos - 2),495,18);

        //rodape
        if($yPos < 180){
             $pdf->ezNewPage();
        }

        //Cabecalho da tabela - movimento anterior
        $pdf->ezText(" ",6,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>100),
        'cl2'=>array('justification'=>'left','width'=>295),
        'cl3'=>array('justification'=>'right','width'=>100)
        );

        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(1.0, 1.0, 1.0), 'shadeCol2'=>array(1.0, 1.0, 1.0), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>" " . $dados->movanterior->movdata, 'cl2'=>"Saldo de operaes BMF do Dia", 'cl3'=>$dados->movanterior->movinicial . " ")
        );
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $tbdata = array();
        $alturaborda = 26;
        for($i = 0; $i < sizeof($dados->movanterior->movimento); $i++){
                if( $i == 0 ){
                        $tbdata[] = array('cl1'=>"<b>" . $dados->movanterior->movimento[$i]->datamov, 'cl2'=>"Saldo em C/C - Dia Anterior", 'cl3'=>$dados->movanterior->movimento[$i]->movvalor . "</b>");
                }
                else{
                        $tbdata[] = array('cl1'=>"<b>" . $dados->movanterior->movimento[$i]->datamov, 'cl2'=>$dados->movanterior->movimento[$i]->movdescricao, 'cl3'=>$dados->movanterior->movimento[$i]->movvalor . "</b>");
                }
                
                $alturaborda += 10;
        }
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $tbdata = array(
         array('cl1'=>$dados->movanterior->movdata, 'cl2'=>"Saldo Final do Dia", 'cl3'=>$dados->movanterior->movsaldo . "")
        );
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,$alturaborda);
        $pdf->line(49, ($yPos + 9), 535, ($yPos + 9));

        //saldo cc anterior
        if( trim($dados->saldocc) != "" ){
                $pdf->ezText(" ",9,$textOptions);
                $clparam = array(
                'cl1'=>array('justification'=>'center','width'=>250),
                'cl2'=>array('justification'=>'right','width'=>245)
                );
                $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>7, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
                $tbdata = array(
                 array('cl1'=>"<b>Saldo em Conta Corrente:                  ", 'cl2'=>$dados->saldocc . "</b>                      "),
                 array('cl1'=>"<b>Saldo de operaes BMF:                      ", 'cl2'=>$dados->saldobmf . "</b>                      "),
                 array('cl1'=>"<b>Balano total do cliente na data atual:", 'cl2'=>$dados->baltotal . "</b>                      ")
                );
                $yPos = $pdf->ezTable($tbdata, '', '', $opt);
                
                //se vieram as informacoes do wtr exibe
                if( trim($dados->saldoccwtr) != "" ){
                        $tbdata = array(
                         array('cl1'=>"<b>Saldo no Web Trade de Cliente no arbitrador                                ", 'cl2'=>"</b>                      "),
                         array('cl1'=>"<b>Saldo em Conta Corrente:                  ", 'cl2'=>$dados->saldoccwtr . "</b>                      "),
                         array('cl1'=>"<b>Saldo de operaes Web Trade:           ", 'cl2'=>$dados->saldobmfwtr . "</b>                      "),
                         array('cl1'=>"<b>Balano total do cliente na data atual:", 'cl2'=>$dados->baltotalwtr . "</b>                      ")
                        );
                        $yPos = $pdf->ezTable($tbdata, '', '', $opt);
                }
                
                $pdf->setStrokeColor(0,0,0,1);
                $pdf->setColor(0, 0, 0);
                if( $dados->saldoccwtr != "" ){
                        $pdf->rectangle(45,($yPos - 1),495,46);
                        $pdf->rectangle(45,($yPos - 1),495,82);
                }
                else{
                        $pdf->rectangle(45,($yPos - 1),495,37);
                }
        }
        
        //IR normal e day trade
        $pdf->ezText(" ",12,$textOptions);
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>250),
        'cl2'=>array('justification'=>'center','width'=>245)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>7, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Base IR Day-Trade:</b>           " . $dados->baseirdaytrade, 'cl2'=>" ")
        );
        $yPos = $pdf->ezTable($tbdata, '', '', $opt);

        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 1),495,12);

        //obs
        $pdf->ezSetY($yPos);
        $textOptions = array('justification'=>'left');

        $pdf->ezText("",6,$textOptions);
        $y2 = $pdf->ezText("",6,$textOptions);
        $yPos = $pdf->ezText("* Indica que a corretora ou pessoa a ela vinculada atuaram como contraparte neste negcio total ou parcialmente.\r\n",8,$textOptions);
        $yPos = $pdf->ezText($dados->observacao,8,$textOptions);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,($y2 - $yPos + 5));
        // Fim do conteudo do PDF
        
        $pdf->ezStopPageNumbers(1,1);
        
        if ($outputArq != ""){
            $pdfcode = $pdf->ezOutput();
            $fp=fopen($outputArq,'wb');
            fwrite($fp,$pdfcode);
            fclose($fp);
        }
        else{
            $pdf->ezStream();
        }
    }
}


/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// Utility function to parse a XML document from a file 
function xml_parse_from_file($parser, $file) 
{ 
    if(!file_exists($file)) 
    { 
        die("Can't find file \"$file\"."); 
    } 
     
    if(!($fp = @fopen($file, "r")))  
    { 
        die("Can't open file \"$file\"."); 
    } 
     
    while($data = fread($fp, 65536)) 
    { 
        if(!xml_parse($parser, $data, feof($fp))) 
        { 
            return(false); 
        } 
    } 
     
    fclose($fp); 
     
    return(true); 
} 


function start_element($parser, $name, $attrs) 
{ 
    global $elemento, $opliq, $opaberta, $tmp, $opmercadoria;
    
    $elemento = $name;
    
    if($elemento == "OPLIQ"){
        $opliq = new OpLiq();
    }

    if($elemento == "POSABERTA"){
        $tmp->posaberta = new PosAberta;
    }

    if($elemento == "OPMERCADORIA"){
        $opmercadoria = new OpMercadoria;
    }

    if($elemento == "OPABERTA"){
        $opaberta = new OpAberta;
    }

    if($elemento == "GARANTIA"){
            if($tmp->garantia == null){
               $tmp->garantia = new Garantia;
            }
    }

    if($elemento == "MOVANTERIOR"){
            if($tmp->movanterior == null){
               $tmp->movanterior = new Movanterior;
            }
    }

    if($elemento == "MOVIMENTO"){
            if($tmp->movanterior != null){
               $tmp->movanterior->movimento[] = new Movimento;
            }
    }

} 

function stop_element($parser, $name) 
{ 
    global $elemento, $tmp, $dados, $opmercadoria, $opliq, $ultimoDado, $opaberta, $ativo, $opfinanceiro, $operacao;

    if(($name == "CLIENTE") && $tmp != null){
        $dados[] = $tmp;
        $tmp = null;
    }

    if($name == "OPLIQ"){
        $tmp->posliquidada->opliq[] = $opliq;
        $opliq = null;
    }

    if($name == "OPABERTA"){
        $opmercadoria->opaberta[] = $opaberta;
        $opaberta = null;
    }

    if($name == "OPMERCADORIA"){
        $tmp->posaberta->opmercadoria[] = $opmercadoria;
        $opmercadoria = null;
    }

    if($elemento == "GARANTIA"){
            if($tmp->garantia == null){
               $tmp->garantia = new Garantia;
            }
    }

    if($elemento == "MOVANTERIOR"){
            if($tmp->movanterior == null){
               $tmp->movanterior = new Movanterior;
            }
    }

    if($name == "OPFINANCEIRO"){
        $ativo->opfinanceiro[] = $opfinanceiro;
        $opfinanceiro = null;
    }


    if($name == "ATIVO"){
            $tmp->financeiro->ativo[] = $ativo;
            $ativo = null;
    }

    if($name == "OPERACAO"){
            $tmp->operacaodia->operacao[] = $operacao;
            $operacao = null;
    }

    $ultimoDado = "";
    $elemento = "";
} 

function char_data($parser, $data) 
{ 
    global $elemento, $codigo, $tmp, $operacao, $dados, $opliq, $opmercadoria, $opaberta, $ativo, $opfinanceiro, $posaberta, $ultimoDado;

    if($ultimoDado == ""){
        $ultimoDado = $data;
    }
    else{
        $ultimoDado .= $data;
        $data = str_replace("\n", "", $ultimoDado);
    }

    if($elemento == "CODIGO"){
         $tmp = new extrato;
         $tmp->codigo = $data;
    }

    if($tmp != null){
        if($elemento == "NOME"){
            $tmp->nome = $data;
        }

        if($elemento == "CNPJCPF"){
            $tmp->cnpjcpf = $data;
        }

        if($elemento == "ENDERECO"){
            $tmp->endereco = $data;
        }
        
        if($elemento == "CEP"){
            $tmp->cep = $data;
        }

        if($elemento == "CIDADE"){
            $tmp->cidade = $data;
        }

        if($elemento == "BAIRRO"){
            $tmp->bairro = $data;
        }

        if($elemento == "UF"){
            $tmp->uf = $data;
        }

        if($elemento == "DTPREG"){
            $tmp->dtpreg = $data;
        }

        if($elemento == "DTLIQ"){
            $tmp->dtliq = $data;
        }

        if($elemento == "SALDOCC"){
            $tmp->saldocc = $data;
        }

        if($elemento == "SALDOBMF"){
            $tmp->saldobmf = $data;
        }

        if($elemento == "BALTOTAL"){
            $tmp->baltotal = $data;
        }

        if($elemento == "SALDOCCWTR"){
            $tmp->saldoccwtr = $data;
        }

        if($elemento == "SALDOBMFWTR"){
            $tmp->saldobmfwtr = $data;
        }

        if($elemento == "BALTOTALWTR"){
            $tmp->baltotalwtr = $data;
        }

        //operacoes do Dia
        if($elemento == "MERCADORIA"){
            if($tmp->operacaodia == null){
               $tmp->operacaodia = new OperacaoDia;
            }
            $operacao = new Operacao;
            $operacao->mercadoria = $data;
        }

        if($elemento == "MERC"){
            $operacao->merc = $data;
        }

        if($elemento == "CV"){
            $operacao->cv = $data;
        }

        if($elemento == "QTDE"){
            $operacao->qtde = $data;
        }

        if($elemento == "TIPO"){
            $operacao->tipo = $data;
        }

        if($elemento == "COTACAO"){
            $operacao->cotacao = $data;
        }

        if($elemento == "ULTCOTACAO"){
            $operacao->ultcotacao = $data;
        }

        if($elemento == "AJUVAL"){
            $operacao->ajuval = $data;
        }

        if($elemento == "CVINC"){
            $operacao->cvinc = $data;
        }

        if($elemento == "TOTALAJUSTE"){
            $tmp->operacaodia->totalajuste = $data;
        }

        //Pos. Liquidada
        if($elemento == "DATA"){
            if($tmp->posliquidada == null){
               $tmp->posliquidada = new PosLiquidada;
            }
            $opliq->data = $data;
        }

        if($elemento == "TP"){
            $opliq->tp = $data;
        }

        if($elemento == "COMPRA"){
            $opliq->compra = $data;
        }

        if($elemento == "VENDA"){
            $opliq->venda = $data;
        }

        if($elemento == "MERCADLIQ"){
            $opliq->mercadliq = $data;
        }

        if($elemento == "COTACAOLIQ"){
            $opliq->cotacaoliq = $data;
        }

        if($elemento == "CUSTO"){
            $opliq->custo = $data;
        }

        if($elemento == "AJULIQ"){
            $opliq->ajuliq = $data;
        }

        if($elemento == "RESULTLIQ"){
            $opliq->resultliq = $data;
        }

        if($elemento == "DAYTRADE"){
            $tmp->posliquidada->daytrade = $data;
        }

        if($elemento == "DAYTRADECUSTO"){
            $tmp->posliquidada->daytradecusto = $data;
        }

        if($elemento == "DAYTRADEAJUSTE"){
            $tmp->posliquidada->daytradeajuste = $data;
        }

        if($elemento == "POSICAO"){
            $tmp->posliquidada->posicao = $data;
        }

        if($elemento == "POSICAOCUSTO"){
            $tmp->posliquidada->posicaocusto = $data;
        }

        if($elemento == "POSICAOAJUSTE"){
            $tmp->posliquidada->posicaoajuste = $data;
        }

        if($elemento == "RESULTADO"){
            $tmp->posliquidada->resultado = $data;
        }

        if($elemento == "RESULTADOCUSTO"){
            $tmp->posliquidada->resultadocusto = $data;
        }

        if($elemento == "RESULTADOAJUSTE"){
            $tmp->posliquidada->resultadoajuste = $data;
        }

        //Pos. Aberta
        if($elemento == "MERCADORIAABR"){
/*
            if($tmp->posaberta == null){
                $tmp->posaberta = new PosAberta;
            }
            if($opmercadoria == null){
                $opmercadoria = new OpMercadoria;
            }
            $opaberta = new OpAberta;
*/
            $opaberta->mercadoriaabr = $data;
        }

        if($elemento == "MERCABR"){
            $opaberta->mercabr = $data;
        }

        if($elemento == "POSABR"){
            $opaberta->posabr = $data;
        }

        if($elemento == "BASEIRNORMAL"){
            $tmp->baseirnormal = $data;
        }

        if($elemento == "BASEIRDAYTRADE"){
            $tmp->baseirdaytrade = $data;
        }

        if($elemento == "OBSERVACAO"){
            $tmp->observacao = str_replace("[br]", "\n", $data);
        }

        if($elemento == "VENCTOABR"){
            $opaberta->venctoabr = $data;
        }

        if($elemento == "CVABR"){
            $opaberta->cvabr = $data;
        }

        if($elemento == "QTDEABR"){
            $opaberta->qtdeabr = $data;
        }

        if($elemento == "PRECOMEDIOABR"){
            $opaberta->precomedioabr = $data;
        }

        if($elemento == "RESULTADOABR"){
            $opaberta->resultadoabr = $data;
            //$opmercadoria->opaberta[] = $opaberta;
            //$opaberta = null;
        }

        if($elemento == "QTDTOTPORMERC"){
            $opmercadoria->qtdtotpormerc = $data;
        }

        if($elemento == "RESULTTOTPORMERC"){
            $opmercadoria->resulttotpormerc = $data;
        }

        if($elemento == "TOTALCUSTO"){
            $tmp->posaberta->totalcusto = $data;
        }

        if($elemento == "OUROALOC"){
            $tmp->garantia->ouroaloc = $data;
        }

        if($elemento == "OUROUSADO"){
            $tmp->garantia->ourousado = $data;
        }

        if($elemento == "OUROBAL"){
            $tmp->garantia->ourobal = $data;
        }

        if($elemento == "ATIVOALOC"){
            $tmp->garantia->ativoaloc = $data;
        }

        if($elemento == "ATIVOUSADO"){
            $tmp->garantia->ativousado = $data;
        }

        if($elemento == "ATIVOBAL"){
            $tmp->garantia->ativobal = $data;
        }

        if($elemento == "DINHEIROALOC"){
            $tmp->garantia->dinheiroaloc = $data;
        }

        if($elemento == "DINHEIROUSADO"){
            $tmp->garantia->dinheirousado = $data;
        }

        if($elemento == "DINHEIROBAL"){
            $tmp->garantia->dinheirobal = $data;
        }

        if($elemento == "DINHEIRODEV"){
            $tmp->garantia->dinheirodev = $data;
        }

        if($elemento == "MARGEMREQ"){
            $tmp->garantia->margemreq = $data;
        }

        if($elemento == "TOTALALOC"){
            $tmp->garantia->totalaloc = $data;
        }

        if($elemento == "TOTALUSADO"){
            $tmp->garantia->totalusado = $data;
        }

        if($elemento == "TOTALDEV"){
            $tmp->garantia->totaldev = $data;
        }

        if($elemento == "TOTALBAL"){
            $tmp->garantia->totalbal = $data;
        }

        //Movimento Anterior
        if($elemento == "MOVDESCRICAO"){
                if($tmp->movanterior != null){
                        $ult = sizeof($tmp->movanterior->movimento) - 1;
                        $tmp->movanterior->movimento[$ult]->movdescricao = $data;
                }
        }

        if($elemento == "MOVVALOR"){
                if($tmp->movanterior != null){
                        $ult = sizeof($tmp->movanterior->movimento) - 1;
                        $tmp->movanterior->movimento[$ult]->movvalor = $data;
                }
        }

        if($elemento == "DATAMOV"){
                if($tmp->movanterior != null){
                        $ult = sizeof($tmp->movanterior->movimento) - 1;
                        $tmp->movanterior->movimento[$ult]->datamov = $data;
                }
        }

        if($elemento == "MOVDATA"){
                if($tmp->movanterior != null){
                        $tmp->movanterior->movdata = $data;
                }
        }

        if($elemento == "MOVINICIAL"){
                if($tmp->movanterior != null){
                        $tmp->movanterior->movinicial = $data;
                }
        }
        
        if($elemento == "MOVSALDO"){
                if($tmp->movanterior != null){
                        $tmp->movanterior->movsaldo = $data;
                }
        }

        //Financeiro
        if($elemento == "NOMEATIVO"){
            if($tmp->financeiro == null){
               $tmp->financeiro = new Financeiro;
            }
            $ativo = new Ativo;
            $ativo->nomeativo = $data;
        }

        if($elemento == "HISTORICO"){
            $opfinanceiro = new OpFinanceiro;
            $opfinanceiro->historico = $data;
        }

        if($elemento == "DEBITOFIN"){
            $opfinanceiro->debitofin = $data;
        }

        if($elemento == "CREDITOFIN"){
            $opfinanceiro->creditofin = $data;
        }

        if($elemento == "TOTALATIVO"){
            $ativo->totalativo = $data;
        }

        if($elemento == "BALANCOBMF"){
            $tmp->financeiro->balancobmf = $data;
        }
        
    }
} 

?>