<? 
/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// The base class for an element 
class Resumo{ 
    var $vendasdisp = "";
    var $comprasdisp = "";
    var $vendasop = "";
    var $comprasop = "";
    var $outros = "";
    var $irrfday = "";
    var $irrfencerrado = "";
    var $irsemcorret = "";
    var $ajustepos = "";
    var $ajustedia = "";
    var $corretlegal = "";
    var $txregistro = "";
    var $txpermanencia = "";
    var $txbmf = "";
    var $txmcwtr = "";
    var $saldoliq = "";
    var $saldobruto = "";
    var $saldoliqdata = "";
    var $baseirnormal = "";
    var $baseirdaytrade = "";
    var $observacao = "";
}

class extrato 
{ 
    var $codigo = "";
    var $nome = "";
    var $cnpjcpf = "";
    var $endereco = "";
    var $cep = "";
    var $cidade = "";
    var $bairro = "";
    var $uf = "";
    var $nrnota = "";
    var $dtpreg = "";
    var $dtliq = "";
    var $operacao = array();
    var $resumo = null;
} 

class Operacao{ 
    var $cv = "";
    var $merc = "";
    var $mercadoria = "";
    var $vencto = "";
    var $qtde = "";
    var $cotacao = "";
    var $tipo = "";
    var $ajuval = "";
    var $dc = "";
    var $corretliq = "";
    var $cvinc = "";
}


// don't want any warnings turning up in the pdf code if the server is set to 'anal' mode.
//error_reporting(7);
error_reporting(E_ALL);
set_time_limit(1800);

include 'class.ezpdf.php';

// define a clas extension to allow the use of a callback to get the table of contents, and to put the dots in the toc
class Creport extends Cezpdf {

var $reportContents = array();

function Creport($p,$o){
  $this->Cezpdf($p,$o);
}

function rf($info){
  // this callback records all of the table of contents entries, it also places a destination marker there
  // so that it can be linked too
  $tmp = $info['p'];
  $lvl = $tmp[0];
  $lbl = rawurldecode(substr($tmp,1));
  $num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
  $this->reportContents[] = array($lbl,$num,$lvl );
  $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
}

    function dots($info){
      // draw a dotted line over to the right and put on a page number
      $tmp = $info['p'];
      $lvl = $tmp[0];
      $lbl = substr($tmp,1);
      $xpos = 520;
    
      switch($lvl){
        case '1':
          $size=16;
          $thick=1;
          break;
        case '2':
          $size=12;
          $thick=0.5;
          break;
      }
    
      $this->saveState();
      $this->setLineStyle($thick,'round','',array(0,10));
      $this->line($xpos,$info['y'],$info['x']+5,$info['y']);
      $this->restoreState();
      $this->addText($xpos+5,$info['y'],$size,$lbl);
    
    
    }

}


class ExtratoPDF{

    function makePDF($dados, $outputArq=""){
        //===================================================================================================
        //Iniciando a geracao do pdf
        //===================================================================================================
        // this is the php file which creates the readme.pdf file, this is not seriously 
        //Teste
        //===================================================================================================
        
        //Variavel para guardar a ultima posicao vertical usada
        $yPos = 0;
        
        // I am in NZ, so will design my page for A4 paper.. but don't get me started on that.
        // (defaults to legal)
        // this code has been modified to use ezpdf.
        
        //$pdf = new Cezpdf('a4','portrait');
        $pdf = new Creport('a4','portrait');
        
        $pdf -> ezSetMargins(100,100,55,55);
        
        // put a line top and bottom on all the pages
        $all = $pdf->openObject();
        $pdf->saveState();
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->addText(50, 800, 10, "<b>Nota de Corretagem</b>");
        $pdf->addText(50, 780, 8, "Negcios realizados em BM&F");
        $pdf->addText(300, 795, 8, "<b>N Nota                  Pgina               Dt. Prego              Data Liq.</b>");
        $pdf->addText(305, 785, 8, $dados->nrnota);
        $pdf->addText(425, 785, 8, $dados->dtpreg);
        $pdf->addText(490, 785, 8, $dados->dtliq);
        $pdf->setLineStyle(1);
        $pdf->line(290,805,540,805);
        $pdf->line(290,780,540,780);
        $pdf->line(290,805,290,780);
        $pdf->line(350,805,350,780);
        $pdf->line(410,805,410,780);
        $pdf->line(480,805,480,780);
        $pdf->line(540,805,540,780);
        
        $pdf->restoreState();
        $pdf->closeObject();
        // note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
        // or 'even'.
        $pdf->addObject($all,'all');
        
        //$pdf->ezSetDy(-100);
        
        //$mainFont = './fonts/Helvetica.afm';
        $mainFont = './fonts/Times-Roman.afm';
        $codeFont = './fonts/Courier.afm';
        // select a font
        $pdf->selectFont($mainFont);
        
        
        // modified to use the local file if it can
        
        $pdf->openHere('Fit');
        
        $pdf->selectFont($mainFont);
        
        //-----------------------------------------------------------
        $pdf->ezStartPageNumbers(385,785,8,'','{PAGENUM} de {TOTALPAGENUM}',1);
        
        $size=8;
        $height = $pdf->getFontHeight($size);
        $textOptions = array('justification'=>'center');
        $collecting=0;
        $code='';
        
        // Comeca a jogar o conteudo no PDF
        
        //Cabecalho Commcor
        $pdf->setColor(0.71, 0.92, 0.88);
        $pdf->filledRectangle(131,757,250,12);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(131,757,250,12);
        $pdf->rectangle(45,710,495,65);
        $pdf->rectangle(45,670,360,35);
        $pdf->rectangle(405,670,135,35);
        if (file_exists('logo_terrafuturos.jpg')){
          $pdf->addJpegFromFile('logo_terrafuturos.jpg',55,730,71,35);
        }
        $pdf->addText(136, 760, 8, "<b>Terra Futuros Corretora de Mercadorias S.A.</b>");
        $pdf->addText(136, 745, 8, "Tenente Negro, 140  11 ANDAR                                               FONE: (11) 3165-6006");
        $pdf->addText(136, 735, 8, "Itaim Bibi                                                     SO PAULO - SP");
        $pdf->addText(136, 725, 8, "CEP: 04530-030");
        $pdf->addText(136, 715, 8, "CNPJ: 03.751.794/0001-13");

        //cabecalho cliente
        $pdf->addText(50, 695, 8, "<b>Cliente:</b>    " . $dados->codigo . "     " . $dados->nome);
        $pdf->addText(50, 685, 8, $dados->endereco);
        $pdf->addText(50, 675, 8, "<b>CEP:</b>    " . $dados->cep . "        " . $dados->cidade . "        " . $dados->uf . "        " . $dados->bairro);
        $pdf->addText(410, 695, 8, "<b>Conta Liquidao:</b>         " . $dados->codigo);
        $pdf->addText(410, 675, 8, "<b>CNPJ/CPF:</b>     " . $dados->cnpjcpf);

        $pdf->ezText(" ",16,$textOptions);
        $pdf->ezText(" ",16,$textOptions);
        $pdf->ezText(" ",16,$textOptions);
        $pdf->ezText(" ",16,$textOptions);
        $pdf->ezText(" ",8,$textOptions);
        $textOptions = array('justification'=>'left');


        //Cabecalho da tabela
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>30),
        'cl2'=>array('justification'=>'center','width'=>50),
        'cl3'=>array('justification'=>'center','width'=>50),
        'cl4'=>array('justification'=>'center','width'=>50),
        'cl5'=>array('justification'=>'center','width'=>40),
        'cl6'=>array('justification'=>'center','width'=>50),
        'cl7'=>array('justification'=>'center','width'=>55),
        'cl8'=>array('justification'=>'center','width'=>60),
        'cl9'=>array('justification'=>'center','width'=>30),
        'cl10'=>array('justification'=>'center','width'=>50),
        'cl11'=>array('justification'=>'center','width'=>30)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>C/V", 'cl2'=>"Mercado", 'cl3'=>"Mercadoria", 'cl4'=>"Vencto.", 'cl5'=>"Qtde.", 'cl6'=>"Preo/ajuste", 'cl7'=>"Tipo", 'cl8'=>"Aju./Val.", 'cl9'=>"D/C", 'cl10'=>"Corretagem</b>", 'cl11'=>"C.Vinc</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        //Dados
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>30),
        'cl2'=>array('justification'=>'center','width'=>50),
        'cl3'=>array('justification'=>'center','width'=>50),
        'cl4'=>array('justification'=>'center','width'=>50),
        'cl5'=>array('justification'=>'center','width'=>40),
        'cl6'=>array('justification'=>'center','width'=>50),
        'cl7'=>array('justification'=>'center','width'=>55),
        'cl8'=>array('justification'=>'center','width'=>60),
        'cl9'=>array('justification'=>'center','width'=>30),
        'cl10'=>array('justification'=>'center','width'=>50),
        'cl11'=>array('justification'=>'center','width'=>30)
        );
        $opt = array('showLines'=>1, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>7, 'fontSize'=>6, 'shadeCol'=>array(0.82, 0.97, 0.94), 'shadeCol2'=>array(0.82, 0.97, 0.94), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array();

        for($k = 0; $k < sizeof($dados->operacao); $k++){
            $tbdata[] = array('cl1'=>$dados->operacao[$k]->cv, 'cl2'=>$dados->operacao[$k]->merc, 'cl3'=>$dados->operacao[$k]->mercadoria, 'cl4'=>$dados->operacao[$k]->vencto, 'cl5'=>$dados->operacao[$k]->qtde, 'cl6'=>$dados->operacao[$k]->cotacao, 'cl7'=>$dados->operacao[$k]->tipo, 'cl8'=>$dados->operacao[$k]->ajuval, 'cl9'=>$dados->operacao[$k]->dc, 'cl10'=>$dados->operacao[$k]->corretliq, 'cl11'=>$dados->operacao[$k]->cvinc);
        }

        if(sizeof($tbdata) > 0){
            $yPos = $pdf->ezTable($tbdata, '', '', $opt);
        }
        $pdf->ezText("* indica que a corretora ou pessoa a ela vinculada atuaram como contraparte neste negcio total ou parcialmente.",8,$textOptions);
        
        if($yPos < 280){
             $pdf->ezNewPage();
        }

        //Rodape
        $pdf->ezText("",10,$textOptions);
        $yPos = $pdf->ezText("Resumo dos Negcios",10,$textOptions);

        //tabela resumo
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>75),
        'cl2'=>array('justification'=>'left','width'=>110),
        'cl3'=>array('justification'=>'right','width'=>70),
        'cl4'=>array('justification'=>'center','width'=>30),
        'cl5'=>array('justification'=>'left','width'=>140),
        'cl6'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>8, 'fontSize'=>8, 'shaded'=>0, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>" ", 'cl2'=>"<b>Vendas Disponvel</b>", 'cl3'=>$dados->resumo->vendasdisp, 'cl4'=>" ", 'cl5'=>"<b>Ajuste de posio + dia</b>", 'cl6'=>$dados->resumo->ajustepos),
         array('cl1'=>" ", 'cl2'=>"<b>Compras Disponvel</b>", 'cl3'=>$dados->resumo->comprasdisp, 'cl4'=>" ", 'cl5'=>"<b>Ajuste Day Trade</b>", 'cl6'=>$dados->resumo->ajustedia),
         array('cl1'=>" ", 'cl2'=>"<b>Vendas Opo</b>", 'cl3'=>$dados->resumo->vendasop, 'cl4'=>" ", 'cl5'=>"<b>Corretagem</b>", 'cl6'=>$dados->resumo->corretlegal),
         array('cl1'=>" ", 'cl2'=>"<b>Compras Opo</b>", 'cl3'=>$dados->resumo->comprasop, 'cl4'=>" ", 'cl5'=>"<b>Taxa de Registro</b>", 'cl6'=>$dados->resumo->txregistro),
         array('cl1'=>" ", 'cl2'=>"<b>Outros</b>", 'cl3'=>$dados->resumo->outros, 'cl4'=>" ", 'cl5'=>"<b>Taxa de permanncia</b>", 'cl6'=>$dados->resumo->txpermanencia),
         array('cl1'=>" ", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>" ", 'cl5'=>"<b>Taxas da BMF</b>", 'cl6'=>$dados->resumo->txbmf),
         array('cl1'=>"<b>Base de Clculo</b>", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>" ", 'cl5'=>"<b>Taxa MC/WTR</b>", 'cl6'=>$dados->resumo->txmcwtr)
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>255),
        'cl2'=>array('justification'=>'center','width'=>30),
        'cl3'=>array('justification'=>'left','width'=>140),
        'cl4'=>array('justification'=>'right','width'=>70)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>8, 'fontSize'=>8, 'shaded'=>0, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"1. Lucro lquido das operaes Day-Trade", 'cl2'=>" ", 'cl3'=>"<b>Saldo Bruto</b>", 'cl4'=>$dados->resumo->saldobruto),
         array('cl1'=>"2. Ajuste positivo das operaes normais encerradas", 'cl2'=>" ", 'cl3'=>"<b>IRRF Sobre Operaes Day-Trade (1)</b>", 'cl4'=>$dados->resumo->irrfday),
         array('cl1'=>" ", 'cl2'=>" ", 'cl3'=>"<b>IRRF Sobre Operaes Encerradas (2)</b>", 'cl4'=>$dados->resumo->irrfencerrado),
         array('cl1'=>" ", 'cl2'=>" ", 'cl3'=>"<b>Saldo Lquido P/   " . $dados->resumo->saldoliqdata . "</b>", 'cl4'=>$dados->resumo->saldoliq)
        );
        $pdf->ezTable($tbdata, '', '', $opt);

	$pdf->ezText("",8,$textOptions);

        $clparam = array(
        'cl1'=>array('justification'=>'left','width'=>195),
        'cl2'=>array('justification'=>'right','width'=>65),
        'cl3'=>array('justification'=>'center','width'=>20),
        'cl4'=>array('justification'=>'left','width'=>150),
        'cl5'=>array('justification'=>'right','width'=>65)
        );
        $opt = array('showLines'=>0, 'showHeadings'=>0, 'width'=>495, 'titleFontSize'=>8, 'fontSize'=>8, 'shaded'=>0, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Informativos</b>", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>"Base IR Normal", 'cl5'=>$dados->resumo->baseirnormal),
         array('cl1'=>"IR sobre Corretagem (1,5%):", 'cl2'=>$dados->resumo->irsemcorret, 'cl3'=>" ", 'cl4'=>"Base IR Day-Trade", 'cl5'=>$dados->resumo->baseirdaytrade),
         array('cl1'=>"A Corretagem  proporcional ao movimento do dia", 'cl2'=>" ", 'cl3'=>" ", 'cl4'=>" ", 'cl5'=>" ")
        );
        $pdf->ezTable($tbdata, '', '', $opt);

        $pdf->setLineStyle(1);
        $pdf->setStrokeColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 200),495,197);
        $pdf->line(320,($yPos - 10),320,($yPos - 195));
        $pdf->line(50,($yPos - 77),320,($yPos - 77));
        $pdf->line(50,($yPos - 152),535,($yPos - 152));

        if (file_exists('bmf.jpg')){
          $pdf->addJpegFromFile('bmf.jpg',60,($yPos - 70),51,35);
        }

        if(isset($dados->observacao)){
            $pdf->addText(50, ($yPos - 220), 8, $dados->observacao);
        }
        else{
            $pdf->addText(50, ($yPos - 220), 8, " ");
        }

        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 225),495,15);


        // Fim do conteudo do PDF
        $pdf->ezStopPageNumbers(1,1);
        
        if ($outputArq != ""){
            $pdfcode = $pdf->ezOutput();
            $fp=fopen($outputArq,'wb');
            fwrite($fp,$pdfcode);
            fclose($fp);
        }
        else{
            $pdf->ezStream();
        }
    }
}


/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// Utility function to parse a XML document from a file 
function xml_parse_from_file($parser, $file) 
{ 
    if(!file_exists($file)) 
    { 
        die("Can't find file \"$file\"."); 
    } 
     
    if(!($fp = @fopen($file, "r")))  
    { 
        die("Can't open file \"$file\"."); 
    } 
     
    while($data = fread($fp, 65536)) 
    { 
        if(!xml_parse($parser, $data, feof($fp))) 
        { 
            return(false); 
        } 
    } 
     
    fclose($fp); 
     
    return(true); 
} 


function start_element($parser, $name, $attrs) 
{ 
    global $elemento;
    
    $elemento = $name;
} 

function stop_element($parser, $name) 
{ 
    global $elemento, $tmp, $dados, $ultimoDado, $operacao;

    if(($name == "CLIENTE") && $tmp != null){
        $dados[] = $tmp;
        $tmp = null;
    }


    if(($name == "OPERACAO") && $tmp != null){
        $tmp->operacao[] = $operacao;
        $operacao = null;
    }

    $ultimoDado = "";
    $elemento = "";
} 

function char_data($parser, $data) 
{ 
    global $elemento, $codigo, $pregao, $tmp, $operacao, $dados, $ultimoDado;

    if($ultimoDado == ""){
        $ultimoDado = $data;
    }
    else{
        $ultimoDado .= $data;
        $data = str_replace("\n", "", $ultimoDado);
    }

    if($elemento == "CODIGO"){
         $tmp = new extrato;
         $tmp->codigo = $data;
         $tmp->resumo = new Resumo();
    }

    if($tmp != null){
        if($elemento == "NOME"){
            $tmp->nome = $data;
        }

        if($elemento == "CNPJCPF"){
            $tmp->cnpjcpf = $data;
        }

        if($elemento == "OBSERVACAO"){
            $tmp->observacao = str_replace("[br]", "\n", $data);
        }

        if($elemento == "ENDERECO"){
            $tmp->endereco = $data;
        }
        
        if($elemento == "CEP"){
            $tmp->cep = $data;
        }

        if($elemento == "CIDADE"){
            $tmp->cidade = $data;
        }

        if($elemento == "BAIRRO"){
            $tmp->bairro = $data;
        }

        if($elemento == "UF"){
            $tmp->uf = $data;
        }

        if($elemento == "NRNOTA"){
            $tmp->nrnota = $data;
        }

        if($elemento == "DTPREG"){
            $tmp->dtpreg = $data;
        }

        if($elemento == "DTLIQ"){
            $tmp->dtliq = $data;
        }

        //operacoes
        if($elemento == "CV"){
            $operacao = new Operacao;
            $operacao->cvinc = " ";//valor default pra cvinc caso o campo nao exista na estrutura
            $operacao->cv = $data;
        }

        if($elemento == "MERC"){
            $operacao->merc = $data;
        }

        if($elemento == "MERCADORIA"){
            $operacao->mercadoria = $data;
        }

        if($elemento == "VENCTO"){
            $operacao->vencto = $data;
        }

        if($elemento == "QTDE"){
            $operacao->qtde = $data;
        }

        if($elemento == "COTACAO"){
            $operacao->cotacao = $data;
        }

        if($elemento == "TIPO"){
            $operacao->tipo = $data;
        }

        if($elemento == "AJUVAL"){
            $operacao->ajuval = $data;
        }

        if($elemento == "DC"){
            $operacao->dc = $data;
        }

        if($elemento == "CORRETLIQ"){
            $operacao->corretliq = $data;
        }

        if($elemento == "CVINC"){
            $operacao->cvinc = $data;
        }

        //resumo
        if($elemento == "VENDASDISP"){
            $tmp->resumo->vendasdisp = $data;
        }

        if($elemento == "VENDASDISP"){
            $tmp->resumo->vendasdisp = $data;
        }

        if($elemento == "COMPRASDISP"){
            $tmp->resumo->comprasdisp = $data;
        }

        if($elemento == "VENDASDISP"){
            $tmp->resumo->vendasdisp = $data;
        }

        if($elemento == "COMPRASOP"){
            $tmp->resumo->comprasop = $data;
        }

        if($elemento == "VENDASOP"){
            $tmp->resumo->vendasop = $data;
        }

        if($elemento == "OUTROS"){
            $tmp->resumo->outros = $data;
        }

        if($elemento == "IRRFDAY"){
            $tmp->resumo->irrfday = $data;
        }

        if($elemento == "IRRFENCERRADO"){
            $tmp->resumo->irrfencerrado = $data;
        }

        if($elemento == "IRSEMCORRET"){
            $tmp->resumo->irsemcorret = $data;
        }

        if($elemento == "AJUSTEPOS"){
            $tmp->resumo->ajustepos = $data;
        }

        if($elemento == "AJUSTEDIA"){
            $tmp->resumo->ajustedia = $data;
        }

        if($elemento == "CORRETLEGAL"){
            $tmp->resumo->corretlegal = $data;
        }

        if($elemento == "TXREGISTRO"){
            $tmp->resumo->txregistro = $data;
        }

        if($elemento == "TXPERMANENCIA"){
            $tmp->resumo->txpermanencia = $data;
        }

        if($elemento == "TXBMF"){
            $tmp->resumo->txbmf = $data;
        }

        if($elemento == "TAXAMCWTR"){
            $tmp->resumo->txmcwtr = $data;
        }

        if($elemento == "SALDOLIQ"){
            $tmp->resumo->saldoliq = $data;
        }

        if($elemento == "SALDOBRUTO"){
            $tmp->resumo->saldobruto = $data;
        }

        if($elemento == "SALDOLIQDATA"){
            $tmp->resumo->saldoliqdata = $data;
        }

        if($elemento == "BASEIRNORMAL"){
            $tmp->resumo->baseirnormal = $data;
        }

        if($elemento == "BASEIRDAYTRADE"){
            $tmp->resumo->baseirdaytrade = $data;
        }

    }
} 

?>