<? 
/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// The base class for an element 
class extrato 
{ 
    var $codigo = "";
    var $nome = "";
    var $contato = "";
    var $pregao = "";
    var $totalcompra = "";
    var $totalvenda = "";
    var $mercadoria = array();
    var $observacao = "";
} 

class compravenda 
{ 
    var $merc = "";
    var $qtd = "";
    var $preco = "";
}

class mercadoria 
{ 
    var $compras = array();
    var $vendas = array();
    var $totalcompramerc = "";
    var $totalvendamerc = "";

    function getCompra($pos, $ocampo){
    	if($pos < sizeof($this->compras)){
            if($ocampo == "merc"){
            	return($this->compras[$pos]->merc);
            }
            if($ocampo == "qtd"){
            	return($this->compras[$pos]->qtd);
            }
            if($ocampo == "preco"){
            	return($this->compras[$pos]->preco);
            }
            if($ocampo == "saldo"){
            	return($this->compras[$pos]->saldo);
            }
    	}
    	else{
    	    return(" ");
        }
    }

    function getVenda($pos, $ocampo){
    	if($pos < sizeof($this->vendas)){
            if($ocampo == "merc"){
            	return($this->vendas[$pos]->merc);
            }
            if($ocampo == "qtd"){
            	return($this->vendas[$pos]->qtd);
            }
            if($ocampo == "preco"){
            	return($this->vendas[$pos]->preco);
            }
    	}
    	else{
    	    return(" ");
        }
    }
}


// don't want any warnings turning up in the pdf code if the server is set to 'anal' mode.
//error_reporting(7);
error_reporting(E_ALL);
set_time_limit(1800);

include 'class.ezpdf.php';

// define a clas extension to allow the use of a callback to get the table of contents, and to put the dots in the toc
class Creport extends Cezpdf {

var $reportContents = array();

function Creport($p,$o){
  $this->Cezpdf($p,$o);
}

function rf($info){
  // this callback records all of the table of contents entries, it also places a destination marker there
  // so that it can be linked too
  $tmp = $info['p'];
  $lvl = $tmp[0];
  $lbl = rawurldecode(substr($tmp,1));
  $num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
  $this->reportContents[] = array($lbl,$num,$lvl );
  $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
}

    function dots($info){
      // draw a dotted line over to the right and put on a page number
      $tmp = $info['p'];
      $lvl = $tmp[0];
      $lbl = substr($tmp,1);
      $xpos = 520;
    
      switch($lvl){
        case '1':
          $size=16;
          $thick=1;
          break;
        case '2':
          $size=12;
          $thick=0.5;
          break;
      }
    
      $this->saveState();
      $this->setLineStyle($thick,'round','',array(0,10));
      $this->line($xpos,$info['y'],$info['x']+5,$info['y']);
      $this->restoreState();
      $this->addText($xpos+5,$info['y'],$size,$lbl);
    
    
    }

}


class ExtratoPDF{

    function makePDF($dados, $outputArq=""){
        //===================================================================================================
        //Iniciando a geracao do pdf
        //===================================================================================================
        // this is the php file which creates the readme.pdf file, this is not seriously 
        //Teste
        //===================================================================================================
        
        
        // I am in NZ, so will design my page for A4 paper.. but don't get me started on that.
        // (defaults to legal)
        // this code has been modified to use ezpdf.
        
        //$pdf = new Cezpdf('a4','portrait');
        $pdf = new Creport('a4','portrait');
        
        $pdf -> ezSetMargins(100,100,55,55);
        
        // put a line top and bottom on all the pages
        $all = $pdf->openObject();
        $pdf->saveState();
        $pdf->setStrokeColor(0,0,0,1);
        
        
        if (file_exists('logo_terrafuturos.jpg')){
          $pdf->addJpegFromFile('logo_terrafuturos.jpg',50,760,93,46);
        }
        //$pdf->addText(55, 750, 8, "Tenente Negro - 140 - 11 Andar CJ. 22B - CEP:04530-030");
        //$pdf->addText(55, 740, 8, "SAO PAULO - SP   TEL: (011) 3165 6000 - CNPJ: 03.751.794/0001-13");
        
        
        //$pdf->line(20,40,578,40);
        $pdf->restoreState();
        $pdf->closeObject();
        // note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
        // or 'even'.
        $pdf->addObject($all,'all');
        
        //$pdf->ezSetDy(-100);
        
        //$mainFont = './fonts/Helvetica.afm';
        $mainFont = './fonts/Times-Roman.afm';
        $codeFont = './fonts/Courier.afm';
        // select a font
        $pdf->selectFont($mainFont);
        
        
        // modified to use the local file if it can
        
        $pdf->openHere('Fit');
        
        $pdf->selectFont($mainFont);
        
        //-----------------------------------------------------------
        $pdf->ezStartPageNumbers(500,800,8,'','Pgina: {PAGENUM}',1);
        
        $size=10;
        $height = $pdf->getFontHeight($size);
        $textOptions = array('justification'=>'center');
        $collecting=0;
        $code='';
        
        // Comeca a jogar o conteudo no PDF
        $pdf->addText(230, 800, 10, "<b>Confirmao do Prego</b>");
        $pdf->addText(55, 730, 10, "<b>Terra Futuros Corretora de Mercadorias S.A.</b>");
        $pdf->addText(467, 790, 8, "Data: " . date("d/m/Y"));
        $pdf->addText(467, 780, 8, "Hora: " . date("h:i:s"));
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $textOptions = array('justification'=>'left');
        $pdf->ezText("<b>Prego  " . $dados->pregao . "</b>",$size,$textOptions);

        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(52,691,500,30);
        $pdf->ezText("Cliente: " . $dados->codigo . "        " . $dados->nome,$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText("A/C " . $dados->contato,$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        $pdf->ezText("Informamos a V.Sa. os negocios realizados por esta corretora, em BM&F:",$size,$textOptions);
        $pdf->ezText(" ",$size,$textOptions);
        
        //Cabecalho da tabela
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>200),
        'cl2'=>array('justification'=>'center','width'=>30),
        'cl3'=>array('justification'=>'center','width'=>200)
        );
        $opt = array('showHeadings'=>0, 'width'=>430, 'titleFontSize'=>8, 'fontSize'=>8, 'shaded'=>0, 'cols'=>$clparam, 'showLines'=>0);
        $tbdata = array(
         array('cl1'=>"<b>COMPRAS</b>", 'cl2'=>" ", 'cl3'=>"<b>VENDAS</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);
        
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>70),
        'cl2'=>array('justification'=>'center','width'=>65),
        'cl3'=>array('justification'=>'center','width'=>65),
        'cl4'=>array('justification'=>'center','width'=>30),
        'cl5'=>array('justification'=>'center','width'=>70),
        'cl6'=>array('justification'=>'center','width'=>65),
        'cl7'=>array('justification'=>'center','width'=>65)
        );
        $opt = array('showHeadings'=>0, 'width'=>430, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Mercadoria</b>", 'cl2'=>"<b>Quantidade</b>", 'cl3'=>"<b>Preo</b>", 'cl4'=>" ", 'cl5'=>"<b>Mercadoria</b>", 'cl6'=>"<b>Quantidade</b>", 'cl7'=>"<b>Preo</b>")
        );
        $pdf->ezTable($tbdata, '', '', $opt);
        
        
        //Dados
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>70),
        'cl2'=>array('justification'=>'center','width'=>65),
        'cl3'=>array('justification'=>'right','width'=>65),
        'cl4'=>array('justification'=>'center','width'=>30),
        'cl5'=>array('justification'=>'center','width'=>70),
        'cl6'=>array('justification'=>'center','width'=>65),
        'cl7'=>array('justification'=>'right','width'=>65)
        );
        
	for($k = 0; $k < sizeof($dados->mercadoria); $k++){
        $opt = array('showHeadings'=>0, 'width'=>430, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.82, 0.97, 0.94), 'shadeCol2'=>array(0.82, 0.97, 0.94), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array();
            $ct = (sizeof($dados->mercadoria[$k]->compras) > sizeof($dados->mercadoria[$k]->vendas)) ? sizeof($dados->mercadoria[$k]->compras) : sizeof($dados->mercadoria[$k]->vendas);
            for($i = 0; $i < $ct; $i++){
                $tbdata[] = array('cl1'=>$dados->mercadoria[$k]->getCompra($i, "merc"), 'cl2'=>$dados->mercadoria[$k]->getCompra($i, "qtd"), 'cl3'=>$dados->mercadoria[$k]->getCompra($i, "preco"), 'cl4'=>" ", 'cl5'=>$dados->mercadoria[$k]->getVenda($i, "merc"), 'cl6'=>$dados->mercadoria[$k]->getVenda($i, "qtd"), 'cl7'=>$dados->mercadoria[$k]->getVenda($i, "preco"));
            }
        
            if(sizeof($tbdata) > 0){
                $pdf->ezTable($tbdata, '', '', $opt);
            }

            //rodape da mercadoria
            $clparam = array(
            'cl1'=>array('justification'=>'center','width'=>70),
            'cl2'=>array('justification'=>'center','width'=>65),
            'cl3'=>array('justification'=>'right','width'=>65),
            'cl4'=>array('justification'=>'center','width'=>30),
            'cl5'=>array('justification'=>'center','width'=>70),
            'cl6'=>array('justification'=>'center','width'=>65),
            'cl7'=>array('justification'=>'right','width'=>65)
            );
            $opt = array('showHeadings'=>0, 'width'=>430, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
            $tbdata = array(
             array('cl1'=>"<b>Total</b>", 'cl2'=>"<b>" . $dados->mercadoria[$k]->totalcompramerc . "</b>", 'cl3'=>"", 'cl4'=>" ", 'cl5'=>"<b>Total</b>", 'cl6'=>"<b>" . $dados->mercadoria[$k]->totalvendamerc . "</b>", 'cl7'=>"")
            );
            $pdf->ezTable($tbdata, '', '', $opt);
	}
        
        //rodape da tabela
        $clparam = array(
        'cl1'=>array('justification'=>'center','width'=>70),
        'cl2'=>array('justification'=>'center','width'=>65),
        'cl3'=>array('justification'=>'right','width'=>65),
        'cl4'=>array('justification'=>'center','width'=>30),
        'cl5'=>array('justification'=>'center','width'=>70),
        'cl6'=>array('justification'=>'center','width'=>65),
        'cl7'=>array('justification'=>'right','width'=>65)
        );
        $opt = array('showHeadings'=>0, 'width'=>430, 'titleFontSize'=>8, 'fontSize'=>8, 'shadeCol'=>array(0.71, 0.92, 0.88), 'shadeCol2'=>array(0.71, 0.92, 0.88), 'shaded'=>2, 'cols'=> $clparam);
        $tbdata = array(
         array('cl1'=>"<b>Total Geral</b>", 'cl2'=>"<b>" . $dados->totalcompra . "</b>", 'cl3'=>"", 'cl4'=>" ", 'cl5'=>"<b>Total Geral</b>", 'cl6'=>"<b>" . $dados->totalvenda . "</b>", 'cl7'=>"")
        );
        $pdf->ezTable($tbdata, '', '', $opt);
  
        $pdf->ezText("",8,$textOptions);
        $y2 = $pdf->ezText("",8,$textOptions);
        $yPos = $pdf->ezText($dados->observacao,8,$textOptions);
        $pdf->setStrokeColor(0,0,0,1);
        $pdf->setColor(0, 0, 0);
        $pdf->rectangle(45,($yPos - 5),495,($y2 - $yPos + 5));
        // Fim do conteudo do PDF
        
        //$pdf->ezStopPageNumbers(1,1);
        
        if ($outputArq != ""){
            $pdfcode = $pdf->ezOutput();
            $fp=fopen($outputArq,'wb');
            fwrite($fp,$pdfcode);
            fclose($fp);
        }
        else{
            $pdf->ezStream();
        }
    }
}


/***************************************************************************** 
 * $Title: XML parsing example: Collect statistics about a XML document $    * 
 * $Description:                                                             * 
 * This example uses PHP's expat parser to collect statistical information   *  
 * (like number of distinct elements, children and parents of elements)      * 
 * about a XML document.                                                     * 
 * Call it with the XML file to process as argument:                         * 
 * ./xmlstats_PHP4.php3 test.xml                                             * 
 *                                                                           * 
 * $Requires: Expat                                                          * 
 *            PHP 4.0 built as CGI binary $                                  * 
 *                                                                           * 
 *****************************************************************************/ 

// Utility function to parse a XML document from a file 
function xml_parse_from_file($parser, $file) 
{ 
    if(!file_exists($file)) 
    { 
        die("Can't find file \"$file\"."); 
    } 
     
    if(!($fp = @fopen($file, "r")))  
    { 
        die("Can't open file \"$file\"."); 
    } 
     
    while($data = fread($fp, 65536)) 
    { 
        if(!xml_parse($parser, $data, feof($fp))) 
        { 
            return(false); 
        } 
    } 
     
    fclose($fp); 
     
    return(true); 
} 


function start_element($parser, $name, $attrs) 
{ 
    global $elemento, $mercadoria;
    
    $elemento = $name;

    if($elemento == "MERCADORIA"){
        $mercadoria = new mercadoria;
    }
} 

function stop_element($parser, $name) 
{ 
    global $elemento, $tmp, $dados, $mercadoria, $ultimoDado;

    if(($name == "CLIENTE") && $tmp != null){
        $dados[] = $tmp;
        $tmp = null;
    }

    if($name == "MERCADORIA"){
        $tmp->mercadoria[] = $mercadoria;
        $mercadoria = null;
    }

    $ultimoDado = "";
    $elemento = "";
} 

function char_data($parser, $data) 
{ 
    global $elemento, $codigo, $compra, $tmp, $venda, $dados, $mercadoria, $ultimoDado;

    if($ultimoDado == ""){
        $ultimoDado = $data;
    }
    else{
        $ultimoDado .= $data;
        $data = str_replace("\n", "", $ultimoDado);
    }

    if($elemento == "CODIGO"){
         $tmp = new extrato;
         $tmp->codigo = $data;
    }

    if($tmp != null){
        if($elemento == "NOME"){
            $tmp->nome = $data;
        }

        if($elemento == "CONTATO"){
            $tmp->contato = $data;
        }

        if($elemento == "OBSERVACAO"){
            $tmp->observacao = str_replace("[br]", "\n", $data);
        }

        if($elemento == "PREGAO"){
            $tmp->pregao = $data;
        }
        
        if($elemento == "TOTALCOMPRA"){
            $tmp->totalcompra = $data;
        }

        if($elemento == "TOTALVENDA"){
            $tmp->totalvenda = $data;
        }

        if($elemento == "MERC"){
            $compra = new compravenda;
            $compra->merc = $data;
        }
        
        if($elemento == "QTD"){
            $compra->qtd = $data;
        }
        
        if($elemento == "PRECO"){
            $compra->preco = $data;
            $mercadoria->compras[] = $compra;
            $compra = null;
        }
        
        if($elemento == "MERCV"){
            $venda = new compravenda;
            $venda->merc = $data;
        }
        
        if($elemento == "QTDV"){
            $venda->qtd = $data;
        }
        
        if($elemento == "PRECOV"){
            $venda->preco = $data;
            $mercadoria->vendas[] = $venda;
            $venda = null;
        }

        if($elemento == "TOTALCOMPRAMERC"){
            $mercadoria->totalcompramerc = $data;
        }

        if($elemento == "TOTALVENDAMERC"){
            $mercadoria->totalvendamerc = $data;
        }
        
    }
} 

?>